<div class="content-wrapper" system-wrapper>
    {include "../modules/analytics.block.tpl"}
    
    <section class="wrapper image-wrapper bg-image bg-overlay bg-overlay-300" data-image-src="{get_image("bg")}">
        <div class="container pt-17 pb-19 py-md-20 text-center">
            <div class="row">
                <div class="col-lg-8 col-xl-7 mx-auto" data-cues="slideInDown" data-group="page-title">
                    <h1 class="display-1 text-white text-capitalize fs-60 mb-4 px-md-15 px-lg-0">{__("and_pages_default_8")}</h1>
                    <p class="lead fs-24 text-white lh-sm mb-7 mx-md-13 mx-lg-10">{__("landing_lead_desc")}</p>
                </div>
            </div>
        </div>

        <div class="overflow-hidden">
            <div class="divider text-light mx-n2">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 60">
                <path fill="currentColor" d="M0,0V60H1440V0A5771,5771,0,0,1,0,0Z" />
              </svg>
            </div>
        </div>
    </section>

    <section id="features" class="wrapper bg-light">
        <div class="container pb-15 pb-md-17">
            <div class="row gx-md-5 gy-10 mt-n19 mb-14 mb-md-15">
                <div class="col-md-6 col-xl-3">
                    <div class="card shadow-lg text-center">
                        <div class="card-body">
                            <h4>{__("and_pages_default_29")}</h4>
                            <p class="mb-2">
                                {__("and_pages_default_31")}
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-xl-3">
                    <div class="card shadow-lg text-center">
                        <div class="card-body">
                            <h4>{__("and_pages_default_40")}</h4>
                            <p class="mb-2">
                                {__("and_pages_default_42")}
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-xl-3">
                    <div class="card shadow-lg text-center">
                        <div class="card-body">
                            <h4>{__("and_pages_default_51")}</h4>
                            <p class="mb-2">
                                {__("and_pages_default_53")}
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-xl-3">
                    <div class="card shadow-lg text-center">
                        <div class="card-body">
                            <h4>{__("and_pages_default_62")}</h4>
                            <p class="mb-2">
                                {__("and_pages_default_64")}
                            </p>   
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-10 offset-md-1 col-lg-8 offset-lg-2 mx-auto text-center">
                <h2 class="fs-16 text-uppercase text-muted mb-3">{__("and_pages_default_73")}</h2>
                    <h3 class="display-3 text-capitalize mb-10 px-xl-10 px-xxl-15">{__("and_pages_default_74")}</h3>
                </div>
            </div>

            <div class="row gx-lg-8 gx-xl-12 gy-10 align-items-center">
                <div class="col-lg-6">
                    <figure class="rounded shadow-lg"><img src="{assets("images/hero-1.png")}" srcset="{assets("images/hero-1.png")} 2x" alt="" /></figure>
                </div>

                <div class="col-lg-6">
                    <h2 class="mb-3 text-capitalize">{__("and_pages_default_84")}</h2>
                    <p>
                        {__("and_pages_default_86")}
                    </p>
                    <ul class="icon-list bullet-bg bullet-primary">
                        <li><i class="uil uil-brackets-curly"></i><strong>{__("and_pages_default_89")}</strong> {__("and_pages_default_89_1")}</li>
                        <li><i class="uil uil-shuffle"></i><strong>{__("and_pages_default_90")}</strong> {__("and_pages_default_90_1")}</li>
                        <li><i class="uil uil-language"></i><strong>{__("and_pages_default_91")}</strong> {__("and_pages_default_91_1")}</li>
                    </ul>
                </div>
            </div>

            <div class="row mt-5 gx-lg-8 gx-xl-12 gy-10 align-items-center">
                <div class="col-lg-6">
                    <h2 class="mb-3 text-capitalize">{__("and_pages_default_98")}</h2>
                    <p>
                        {__("and_pages_default_100")}
                    </p>
                    <ul class="icon-list bullet-bg bullet-primary">
                        <li><i class="uil uil-clock"></i><strong>{__("and_pages_default_103")}</strong> {__("and_pages_default_103_1")}</li>
                        <li><i class="uil uil-code-branch"></i><strong>{__("and_pages_default_104")}</strong> {__("and_pages_default_104_1")}</li>
                        <li><i class="uil uil-bolt"></i><strong>{__("and_pages_default_105")}</strong> {__("and_pages_default_105_1")}</li>
                        <li><i class="uil uil-phone"></i><strong>{__("and_pages_default_106")}</strong> {__("and_pages_default_106_1")}</li>
                        <li><i class="uil uil-bolt"></i><strong>{__("and_pages_default_107")}</strong> {__("and_pages_default_107_1")}</li>
                    </ul>
                </div>

                <div class="col-lg-6">
                    <figure class="rounded shadow-lg"><img src="{assets("images/hero-2.png")}" srcset="{assets("images/hero-2.png")} 2x" alt="" /></figure>
                </div>
            </div>
        </div>
    </section>

    <section class="wrapper bg-gray">
        <div class="container py-14 py-md-16">
            <div class="row gx-lg-8 gx-xl-12 gy-10 align-items-center">
                <div class="col-lg-6 position-relative">
                    <div class="shape rounded bg-pale-red rellax d-md-block" data-rellax-speed="0" style="top: 50%; left: 50%; width: 50%; height: 60%; transform: translate(-50%, -50%); z-index: 0;"></div>
                    <div class="row gx-md-5 gy-5 position-relative">
                        <div class="col-6">
                            <img class="img-fluid rounded shadow-lg d-flex col-10 mb-5 ms-auto" src="{assets("images/mini-1.png")}" srcset="{assets("images/mini-1.png")} 2x" alt="" />
                            <img class="img-fluid rounded shadow-lg d-flex col-10 ms-auto" src="{assets("images/mini-2.png")}" srcset="{assets("images/mini-2.png")} 2x" alt="" />
                        </div>

                        <div class="col-6">
                            <img class="img-fluid rounded shadow-lg d-flex col-10 my-5" src="{assets("images/mini-4.png")}" srcset="{assets("images/mini-4.png")} 2x" alt="" />
                            <img class="img-fluid rounded shadow-lg d-flex col-10" src="{assets("images/mini-3.png")}" srcset="{assets("images/mini-3.png")} 2x" alt="" />
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <h3 class="display-4 mb-5 text-capitalize">{__("and_pages_default_137")}</h3>
                    <p class="mb-5">
                        {__("and_pages_default_139")}
                    </p>
                    <div class="row gy-3">
                        <div class="col-xl-6">
                            <ul class="icon-list text-capitalize bullet-bg bullet-primary mb-0">
                                <li>
                                    <span><i class="uil uil-check"></i></span><span>{__("and_pages_default_145")}</span>
                                </li>
                                <li class="mt-3">
                                    <span><i class="uil uil-check"></i></span><span>{__("and_pages_default_148")}</span>
                                </li>
                            </ul>
                        </div>

                        <div class="col-xl-6">
                            <ul class="icon-list text-capitalize bullet-bg bullet-primary mb-0">
                                <li> 
                                    <span><i class="uil uil-check"></i></span><span>{__("and_pages_default_156")}</span>
                                </li>
                                <li class="mt-3">
                                    <span><i class="uil uil-check"></i></span><span>{__("and_pages_default_159")}</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section id="pricing" class="wrapper bg-light">
        <div class="container py-14 py-md-16">
            <h1 class="display-3 text-center">{__("and_pages_default_171")}</h1>
            <div class="pricing-wrapper">
                <div class="row gx-0 gy-6">
                    {foreach $data.packages as $package}
                    <div class="col-md-4">
                        <div class="pricing card shadow-none">
                            <div class="card-body">
                                <h2 class="card-title">{$package.name}</h2>
                                <div class="prices text-dark">
                                    <div class="price"><span class="price-currency">{strtoupper(system_currency)}</span><span class="price-value">{number_format($package.price)}</span> <span class="price-duration">{__("default_pricecolumns_monthlabel")}</span></div>
                                </div>
                                <!--/.prices -->
                                <ul class="icon-list bullet-bg bullet-primary mt-8 mb-9">
                                    {if in_array("sms", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-envelope-send"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_187")}</strong>
                                            {if $package.send_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.send_limit)} {if __s("system_reset_mode") < 2}{__("default_pricecolumns_dailylabel")}{else}{__("default_pricecolumns_monthlylabel")}{/if}{/if}
                                        </span>
                                    </li>
                                    <li>
                                        <i class="uil uil-envelope-receive"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_194")}</strong>
                                            {if $package.receive_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.receive_limit)} {if __s("system_reset_mode") < 2}{__("default_pricecolumns_dailylabel")}{else}{__("default_pricecolumns_monthlylabel")}{/if}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                    {if in_array("whatsapp", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-envelope-send"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_201")}</strong>
                                            {if $package.wa_send_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.wa_send_limit)} {if __s("system_reset_mode") < 2}{__("default_pricecolumns_dailylabel")}{else}{__("default_pricecolumns_monthlylabel")}{/if}{/if}
                                        </span>
                                    </li>
                                    <li>
                                        <i class="uil uil-envelope-receive"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_208")}</strong>
                                            {if $package.wa_receive_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.wa_receive_limit)} {if __s("system_reset_mode") < 2}{__("default_pricecolumns_dailylabel")}{else}{__("default_pricecolumns_monthlylabel")}{/if}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                    {if in_array("android_ussd", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-phone"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_215")}</strong>
                                            {if $package.ussd_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.ussd_limit)} {if __s("system_reset_mode") < 2}{__("default_pricecolumns_dailylabel")}{else}{__("default_pricecolumns_monthlylabel")}{/if}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                    {if in_array("android_notifications", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-bell"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_222")}</strong>
                                            {if $package.notification_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.notification_limit)} {if __s("system_reset_mode") < 2}{__("default_pricecolumns_dailylabel")}{else}{__("default_pricecolumns_monthlylabel")}{/if}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                    {if in_array("sms", split($package.services, ",")) || in_array("whatsapp", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-clock"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_229")}</strong>
                                            {if $package.scheduled_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.scheduled_limit)}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                    <li>
                                        <i class="uil uil-user"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_236")}</strong>
                                            {if $package.contact_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.contact_limit)}{/if}
                                        </span>
                                    </li>
                                    {if in_array("api", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-arrow"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_243")}</strong>
                                            {if $package.key_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.key_limit)}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                    {if in_array("webhooks", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-code-branch"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_250")}</strong>
                                            {if $package.webhook_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.webhook_limit)}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                    {if in_array("actions", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-bolt"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_257")}</strong>
                                            {if $package.action_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.action_limit)}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                    {if in_array("sms", split($package.services, ",")) || in_array("android_ussd", split($package.services, ",")) || in_array("android_notifications", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-android"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_264")}</strong>
                                            {if $package.device_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.device_limit)}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                    {if in_array("whatsapp", split($package.services, ","))}
                                    <li>
                                        <i class="uil uil-whatsapp"></i>
                                        <span>
                                            <strong class="d-block">{__("and_pages_default_271")}</strong>
                                            {if $package.wa_account_limit < 1}{__("default_pricecolumns_unlimitedlabel")}{else}{number_format($package.wa_account_limit)}{/if}
                                        </span>
                                    </li>
                                    {/if}
                                </ul>
                            </div>
                        </div>
                    </div>
                    {/foreach}
                </div>
            </div>
        </div>
    </section>

    <section id="clients" class="wrapper bg-gray">
        <div class="container py-14 py-md-16">
            <h2 class="fs-15 text-uppercase text-muted mb-3">{__("and_pages_default_287")}</h2>
            <div class="row gx-lg-8 mb-10 gy-5">
                <div class="col-lg-12">
                    <h3 class="display-5 text-capitalize mb-0">{__("and_pages_default_290")}</h3>
                </div>
            </div>

            <div class="row row-cols-2 row-cols-md-3 row-cols-xl-5 gx-lg-6 gy-6 justify-content-center">
                <div class="col">
                    <div class="card shadow-lg h-100 align-items-center">
                        <div class="card-body align-items-center d-flex px-3 py-6 p-md-8">
                            <figure class="px-md-3 mb-0"><img src="{site_url}/templates/default/assets/images/clients/1.png"></figure>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card shadow-lg h-100 align-items-center">
                        <div class="card-body align-items-center d-flex px-3 py-6 p-md-8">
                            <figure class="px-md-3 mb-0"><img src="{site_url}/templates/default/assets/images/clients/2.png"></figure>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card shadow-lg h-100 align-items-center">
                        <div class="card-body align-items-center d-flex px-3 py-6 p-md-8">
                            <figure class="px-md-3 mb-0"><img src="{site_url}/templates/default/assets/images/clients/3.png"></figure>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card shadow-lg h-100 align-items-center">
                        <div class="card-body align-items-center d-flex px-3 py-6 p-md-8">
                            <figure class="px-md-3 mb-0"><img src="{site_url}/templates/default/assets/images/clients/4.png"></figure>
                        </div>
                    </div>
                </div>

                <div class="col">
                    <div class="card shadow-lg h-100 align-items-center">
                        <div class="card-body align-items-center d-flex px-3 py-6 p-md-8">
                            <figure class="px-md-3 mb-0"><img src="{site_url}/templates/default/assets/images/clients/5.png"></figure>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
